package kochModel.visitor;

import fp.*;
import kochModel.*;

public class CountVisitor implements IKochVisitor<Integer, Object> {
  
  public static final CountVisitor Singleton = new CountVisitor();

  private CountVisitor() {}
  
  private IFoldAlgo<Koch, Integer, Object> foldAlgo = new IFoldAlgo<Koch, Integer, Object>() {
    public Integer apply( Koch host, Integer base, Object... param) {
      return base + host.execute(CountVisitor.this);
    }
  };
  
  public Integer baseCase(Koch host, Object... param) {
    return 1;
  }
    
  public Integer inductCase(Koch host, Object... param) {
    return host.fold(foldAlgo, 0);
  }
}